/*
 * Decompiled with CFR 0.152.
 */
package com.mariaum.icproxy;

public enum Rank {
    MEMBRO("Membro", 0, "\u00a77"),
    VIP("VIP", 1, "\u00a7e\u00a7lVIP \u00a7f"),
    VIPPLUS("VIP+", 2, "\u00a7e\u00a7lVIP\u00a76\u00a7l+ \u00a7f"),
    YOUTUBER("Youtuber", 3, "\u00a7b\u00a7lYT \u00a7f"),
    DESGINER("Designer", 4, "\u00a75\u00a7lDZN \u00a7f"),
    CONSTRUTOR("Construtor", 5, "\u00a7a\u00a7lCNT \u00a7f"),
    AJUDANTE("Ajudante", 6, "\u00a72\u00a7lAJD \u00a7f"),
    MODERADOR("Moderador", 7, "\u00a76\u00a7lMOD \u00a7f"),
    ADMINISTRADOR("Administrador", 8, "\u00a7c\u00a7lADMIN \u00a7f"),
    DESENVOLVEDOR("Desenvolvedor", 9, "\u00a79\u00a7lDEV \u00a7f"),
    SUBDONA("SubDona", 10, "\u00a75\u00a7lSUB \u00a7f"),
    SUBDONO("SubDono", 11, "\u00a74\u00a7lSUB \u00a7f"),
    DONA("Dona", 12, "\u00a7d\u00a7l\u00a7oDONA \u00a7f"),
    DONO("Dono", 13, "\u00a74\u00a7l\u00a7oDONO \u00a7f");

    private String name;
    private int id;
    private String prefix;
    private String color;

    private Rank(String name, int id, String prefix) {
        this.name = name;
        this.id = id;
        this.prefix = prefix;
        this.color = "\u00a7" + prefix.charAt(1);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getColor() {
        return this.color;
    }

    public boolean isAfter(Rank rank) {
        return this.id > rank.getId();
    }

    public boolean isAfterOrEq(Rank rank) {
        return this.id >= rank.getId();
    }

    public boolean isBefore(Rank rank) {
        return this.id < rank.getId();
    }

    public boolean isBeforeOrEq(Rank rank) {
        return this.id <= rank.getId();
    }

    public static Rank byId(int id) {
        Rank[] rankArray = Rank.values();
        int n = rankArray.length;
        int n2 = 0;
        while (n2 < n) {
            Rank rank = rankArray[n2];
            if (rank.getId() == id) {
                return rank;
            }
            ++n2;
        }
        return MEMBRO;
    }

    public static Rank byName(String name) {
        Rank[] rankArray = Rank.values();
        int n = rankArray.length;
        int n2 = 0;
        while (n2 < n) {
            Rank rank = rankArray[n2];
            if (name.equalsIgnoreCase(rank.getName())) {
                return rank;
            }
            ++n2;
        }
        return MEMBRO;
    }

    public static boolean existRank(String rank) {
        Rank[] rankArray = Rank.values();
        int n = rankArray.length;
        int n2 = 0;
        while (n2 < n) {
            Rank rk = rankArray[n2];
            if (rank.equalsIgnoreCase(rk.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

